% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.ergm.ego.R
\name{gof.ergm.ego}
\alias{gof.ergm.ego}
\alias{plot.gof.ergm.ego}
\title{Conduct Goodness-of-Fit Diagnostics on a Exponential Family Random Graph
Model fit to Egocentrically Sampled Data}
\usage{
\method{gof}{ergm.ego}(
  object,
  ...,
  GOF = c("model", "degree", "espartners"),
  control = control.gof.ergm(),
  verbose = FALSE
)

\method{plot}{gof.ergm.ego}(x, ..., ego.conf.level = 0.95)
}
\arguments{
\item{object}{An \code{\link{ergm.ego}} fit.}

\item{...}{Additional arguments. Unused by \code{\link[=gof.ergm.ego]{gof.ergm.ego()}}, passed to
\code{\link[ergm:gof]{ergm::plot.gof()}} by \code{\link[=plot.gof.ergm.ego]{plot.gof.ergm.ego()}}}

\item{GOF}{A string specifying the statistics whose goodness of fit is to be
evaluated. Currently, only \dQuote{degree}, \dQuote{espartners} and \dQuote{model} are
implemented; see \code{\link[ergm:gof]{gof()}} documentation for details.}

\item{control}{A list to control parameters, constructed using
\code{\link[ergm:control.gof]{control.gof.formula()}} or \code{\link[ergm:control.gof]{control.gof.ergm()}} (which
have different defaults).}

\item{verbose}{Provide verbose information on the progress of the
simulation.}

\item{x}{an object returned by \code{\link[=gof.ergm.ego]{gof.ergm.ego()}}.}

\item{ego.conf.level}{confidence level for the observed statistic estimates as well.}
}
\value{
An object of class \code{\link{gof.ergm.ego}}, inheriting from \code{\link[ergm:gof]{gof.ergm()}}.
}
\description{
\code{\link[=gof.ergm.ego]{gof.ergm.ego()}} implements the \code{\link[ergm:gof]{gof()}} method for
\code{\link{ergm.ego}} fit objects.

An enhanced plotting method is also provided, giving uncertainty bars for the observed statistics as well.
}
\examples{
\donttest{
data(faux.mesa.high)
fmh.ego <- as.egor(faux.mesa.high)

head(fmh.ego)

egofit <- ergm.ego(fmh.ego~edges+degree(0:3)+nodefactor("Race")+nodematch("Race")
                         +nodefactor("Sex")+nodematch("Sex")+absdiff("Grade"), 
                          popsize=network.size(faux.mesa.high))

# Check whether the model "converged":
(modelgof <- gof(egofit, GOF="model"))
plot(modelgof)

# Check whether the model reconstructs the degree distribution:
(deggof <- gof(egofit, GOF="degree"))
plot(deggof)
}
}
\references{
\insertRef{HuGoHa2008}{ergm.ego}
}
\seealso{
For examples, see \code{\link[=ergm.ego]{ergm.ego()}}.
}
\author{
Pavel N. Krivitsky
}
\keyword{models}
