% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/private_scalePredictors.r
\name{.scalePredictors}
\alias{.scalePredictors}
\title{Scales predictors}
\usage{
.scalePredictors(scale, preds, data)
}
\arguments{
\item{scale}{Either \code{NA} (default), or \code{TRUE} or \code{FALSE}. If \code{TRUE}, the predictors will be centered and scaled by dividing by subtracting their means then dividing by their standard deviations. The means and standard deviations will be returned in the model object under an element named "\code{scales}". For example, if you do something like \code{model <- trainGLM(data, scale=TRUE)}, then you can get the means and standard deviations using \code{model$scales$means} and \code{model$scales$sds}. If \code{FALSE}, no scaling is done. If \code{NA} (default), then the function will check to see if non-factor predictors have means ~0 and standard deviations ~1. If not, then a warning will be printed, but the function will continue to do it's operations.}

\item{preds}{A character vector with names of the predictors in \code{data}.}

\item{data}{A data frame.}
}
\description{
Scales predictors.
}
\keyword{internal}
