% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/english.R
\name{as.english}
\alias{as.english}
\alias{english}
\alias{english.default}
\alias{english.numeric}
\alias{as.numeric.english}
\alias{print.english}
\alias{rep.english}
\alias{[.english}
\alias{format.english}
\alias{as.character.english}
\alias{sort.english}
\title{"_PACKAGE"
Numbers in Englis Words}
\usage{
as.english(x, ...)

english(x, ...)

\method{english}{default}(x, ...)

\method{english}{numeric}(x, UK, ...)

\method{as.numeric}{english}(x, ...)

\method{print}{english}(x, ...)

\method{rep}{english}(x, ...)

\method{[}{english}(x, i)

\method{format}{english}(x, ...)

\method{as.character}{english}(x, ...)

\method{sort}{english}(x, decreasing = FALSE, ...)
}
\arguments{
\item{x}{A numerical vector, usually integer.}

\item{...}{Additional arguments passed on, currently mostly ignored}

\item{UK}{Logical, Use the UK (English) style (TRUE) or the USA (American) style (FALSE).
The default can be set as \code{options(english.UK = TRUE)}; if unset, a suitable
style is guessed from the user's current locale.}

\item{i}{Index vector of any kind}

\item{decreasing}{Logical: should the sorting be in decreasing order?}
}
\value{
A numerical object that can be printed as English words, or coerced to
        character as English words
}
\description{
Converts numerical vectors into object that display
as English words
}
\examples{
english(10000) + (-5):5
set.seed(123)
(jumble <- english(sample(1:20)))
sort(jumble)
(x <- english(sample(1:100, 10)))
sort(x)
toupper(english(1:10))
## For mothers of small children:
cat(paste("This is the", ordinal(1:5), "time I've told you!"), sep = "\n")
}
