% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diagnostic_sensitivity.R
\name{plot_diagnostic_sensitivity}
\alias{plot_diagnostic_sensitivity}
\title{Produce Diagnostic Plots for the}
\usage{
plot_diagnostic_sensitivity(indicator_time_series, pressure_time_series)
}
\arguments{
\item{indicator_time_series}{a data frame containing only the state indicator
time series. First column MUST be the time column.}

\item{pressure_time_series}{a data frame containing only the pressure variables.
First column MUST be the time column.}
}
\value{
The function returns a list of ggplot objects combined with patchwork.
For each state and pressure indicator combination 4 diagnostic plots are created:
Q-Q plots, residuals vs- linear predictor, a histogram of the residuals and
response vs. fitted values.
}
\description{
The function \code{plot_diagnostic_sensitivity()} creates diagnostic plots for the
generalized additive models, which are used as basis for the sensitivity scoring
in \code{\link{model_sensitivity}}.
}
\examples{
\dontrun{
plot_diagnostic_sensitivity(
  indicator_time_series = indicator_ts_baltic[, c(1,2)],
  pressure_time_series = pressure_ts_baltic[, c(1,2)]
 )
 }
}
