% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-fable.R
\name{tidy.ESN}
\alias{tidy.ESN}
\title{Estimated coefficients}
\usage{
\method{tidy}{ESN}(x, ...)
}
\arguments{
\item{x}{An object of class \code{mdl_df}, containing an ESN model.}

\item{...}{Currently not in use.}
}
\value{
Coefficients extracted from the object.
}
\description{
Return the estimated coefficients from a trained ESN as 
   \code{tibble}.
}
\examples{
library(tsibble)
library(fable)
AirPassengers \%>\%
as_tsibble() \%>\%
model("ESN" = ESN(value)) \%>\%
tidy()

}
\seealso{
Other tidy functions: 
\code{\link{ESN}()},
\code{\link{filter_esn}()},
\code{\link{fitted.ESN}()},
\code{\link{forecast.ESN}()},
\code{\link{glance.ESN}()},
\code{\link{model_sum.ESN}()},
\code{\link{report.ESN}()},
\code{\link{reservoir}()},
\code{\link{residuals.ESN}()}
}
\concept{tidy functions}
