% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-base.R
\name{plot.esn}
\alias{plot.esn}
\title{Plot internal states of a trained ESN model}
\usage{
\method{plot}{esn}(x, ...)
}
\arguments{
\item{x}{An object of class \code{esn}. The result of a call to \code{train_esn()}.}

\item{...}{Further arguments passed to \code{matplot()}.}
}
\value{
Line chart of internal states.
}
\description{
Plot internal states (i.e., the reservoir) of a trained ESN 
  model as line chart.
}
\examples{
xdata <- as.numeric(AirPassengers)
xmodel <- train_esn(y = xdata)
plot(xmodel)

}
\seealso{
Other base functions: 
\code{\link{forecast_esn}()},
\code{\link{is.esn}()},
\code{\link{is.forecast_esn}()},
\code{\link{is.tune_esn}()},
\code{\link{plot.forecast_esn}()},
\code{\link{plot.tune_esn}()},
\code{\link{print.esn}()},
\code{\link{summary.esn}()},
\code{\link{summary.tune_esn}()},
\code{\link{train_esn}()},
\code{\link{tune_esn}()}
}
\concept{base functions}
