% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relational-expr.R
\name{new_relexpr}
\alias{new_relexpr}
\alias{relexpr_reference}
\alias{relexpr_constant}
\alias{relexpr_function}
\alias{relexpr_comparison}
\alias{relexpr_window}
\alias{relexpr_set_alias}
\title{Relational expressions}
\usage{
new_relexpr(x, class = NULL)

relexpr_reference(name, rel = NULL, alias = NULL)

relexpr_constant(val, alias = NULL)

relexpr_function(name, args, alias = NULL, order_bys = NULL)

relexpr_comparison(cmp_op, exprs)

relexpr_window(
  expr,
  partitions,
  order_bys = list(),
  offset_expr = NULL,
  default_expr = NULL,
  alias = NULL
)

relexpr_set_alias(expr, alias = NULL)
}
\arguments{
\item{x}{An object.}

\item{class}{Classes added in front of the \code{"relational_relexpr"} base class.}

\item{name}{The name of the column or function to reference.}

\item{rel}{The name of the relation to reference.}

\item{alias}{An alias for the new expression.}

\item{val}{The value to use in the constant expression.}

\item{args}{Function arguments, a list of \code{expr} objects.}

\item{order_bys}{which variables to order results by (list).}

\item{cmp_op}{Comparison operator, e.g., \code{"<"} or \code{"=="}.}

\item{exprs}{Expressions to compare, a list of \code{expr} objects.}

\item{expr}{An \code{expr} object.}

\item{partitions}{Partitions, a list of \code{expr} objects.}

\item{offset_expr}{offset relational expression.}

\item{default_expr}{default relational expression.}
}
\value{
an object of class \code{"relational_relexpr"}

an object of class \code{"relational_relexpr"}

an object of class \code{"relational_relexpr"}

an object of class \code{"relational_relexpr"}

an object of class \code{"relational_relexpr"}

an object of class \code{"relational_relexpr"}
}
\description{
These functions provide a backend-agnostic way to construct expression trees
built of column references, constants, and functions.
All subexpressions in an expression tree can have an alias.

\code{new_relexpr()} constructs an object of class \code{"relational_relexpr"}.
It is used by the higher-level constructors,
users should rarely need to call it directly.

\code{relexpr_reference()} constructs a reference to a column.

\code{relexpr_constant()} wraps a constant value.

\code{relexpr_function()} applies a function.
The arguments to this function are a list of other expression objects.

\code{relexpr_comparison()} wraps a comparison expression.

\code{relexpr_window()} applies a function over a window,
similarly to the SQL \code{OVER} clause.

\code{relexpr_set_alias()} assigns an alias to an expression.
}
\examples{
relexpr_set_alias(
  alias = "my_predicate",
  relexpr_function(
    "<",
    list(
      relexpr_reference("my_number"),
      relexpr_constant(42)
    )
  )
)
}
