% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_censoring.R
\name{dtms_censoring}
\alias{dtms_censoring}
\title{Left censoring, right censoring, and gaps in data}
\usage{
dtms_censoring(
  data,
  dtms,
  fromvar = "from",
  tovar = "to",
  timevar = "time",
  idvar = "id",
  print = TRUE,
  printlong = FALSE,
  add = FALSE,
  addtype = "id",
  varnames = c("LEFT", "GAP", "RIGHT")
)
}
\arguments{
\item{data}{Data frame in transition format, as created with \code{dtms_format}.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{fromvar}{Character (optional), name of variable in `data` with starting state. Default is "from".}

\item{tovar}{Character (optional), name of variable in `data` with receiving state. Default is "to".}

\item{timevar}{Character (optional), name of variable in `data` with time scale. Default is "time".}

\item{idvar}{Character (optional), name of variable in `data` with unit ID. Default is "id".}

\item{print}{Logical (optional), print counts? Default is TRUE.}

\item{printlong}{Logical (optional), print cross-tabulation? Default is FALSE.}

\item{add}{Logical (optional), add indicators to data set? Default is FALSE. If TRUE the data frame specified with \code{data} is returned with added columns.}

\item{addtype}{Character (optional), what type of information should be added if add=TRUE. Either "id" or "obs", see details. Default is "id".}

\item{varnames}{Character vector (optional), names of added variables if add=TRUE. Default is "c("LEFT","GAP","RIGHT")".}
}
\value{
Table or data frame.
}
\description{
This function provides an overview of censoring and gaps in the data. It can
do so in several ways: by providing counts of units with left censoring,
right censoring, and gaps; by providing a cross-tabulation of the number of
units with left censoring and/or right censoring and/or gaps; and by
returning a data frame with added indicators on censoring and gaps.
}
\details{
Added variables can be at the unit level or at the observation level. This
is controlled by the argument "addtype". If it is set to "id" then the unit
level is used. In this case the added variables are the same for
each observation  of a unit. For instance, if a unit experiences any gap,
then the added variable has the value TRUE for all observations of that unit.
If "addtype" is set to "obs" the observation level is used and the indicators
are only set to TRUE if they apply to a specific observation. For instance,
if a unit experience right censoring, only the last observation will have
TRUE as the value for the right-censoring indicator; i.e., showing that after
this last observation there is right censoring. This can be helpful for
analyses to understand censoring better.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:19)
# Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Censoring
dtms_censoring(data=estdata,
               dtms=simple)
}
