% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt-copy-semantics.R
\name{dt_copy_semantics}
\alias{dt_copy_semantics}
\alias{set_dt_copy_semantics}
\title{Get or set data.table copy semantics}
\usage{
dt_copy_semantics()

set_dt_copy_semantics(dt_copy_semantics = c("reference", "value"))
}
\arguments{
\item{dt_copy_semantics}{Character string. Either \code{"reference"} or \code{"value"}.}
}
\value{
\itemize{
\item \code{dt_copy_semantics()} returns the current semantics as a string,
\code{"reference"} or \code{"value"}.
\item \code{set_dt_copy_semantics()} sets the semantics, returning the previous
semantics invisibly.
}
}
\description{
These functions control how \code{\link[=maybe_copy_dt]{maybe_copy_dt()}} decides whether to
return a \code{data.table} by reference (in place) or by value (as a deep copy).
}
\details{
The copy semantics are stored in the global option
\code{dtlg_dt_copy_semantics}. The option can take two values:
\itemize{
\item \code{"reference"} (default): inputs are treated with reference semantics.
\itemize{
\item If the input is already a \code{data.table}, it is returned unchanged and
aliases are preserved.
\item If the input is a \code{data.frame}, it is converted to a \code{data.table}
in place via \code{\link[data.table:setDT]{data.table::setDT()}}, mutating the caller’s object.
}
\item \code{"value"}: inputs are treated with value semantics.
\itemize{
\item The input is converted to a \code{data.table} (if necessary) and a deep
copy is returned, leaving the original unchanged.
}
}
}
\examples{
# Get current semantics (defaults to "reference")
dt_copy_semantics()

# Switch to value semantics
old <- set_dt_copy_semantics("value")
dt_copy_semantics()

# Restore previous semantics
set_dt_copy_semantics(old)

}
\seealso{
\code{\link[=maybe_copy_dt]{maybe_copy_dt()}}
}
