% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_dtGAP.R
\name{rf_dtGAP}
\alias{rf_dtGAP}
\title{Visualize a Single Tree from a Conditional Random Forest}
\usage{
rf_dtGAP(
  x = NULL,
  target_lab = NULL,
  show = c("all", "train", "test"),
  tree_index = 1L,
  ntree = 500L,
  mtry = NULL,
  rf_control = NULL,
  data_train = NULL,
  data_test = NULL,
  data_all = NULL,
  test_size = 0.3,
  task = c("classification", "regression"),
  trans_type = c("normalize", "scale", "percentize", "none"),
  col_proximity = c("pearson", "spearman", "kendall"),
  linkage_method = c("CT", "SG", "CP"),
  seriate_method = "TSP",
  cRGAR_w = 5,
  sort_by_data_type = TRUE,
  custom_layout = NULL,
  panel_space = 0.001,
  margin = 20,
  total_w = 297,
  total_h = 210,
  tree_p = 0.3,
  include_var_imp = TRUE,
  col_var_imp = "orange",
  var_imp_bar_width = 0.8,
  var_imp_fontsize = 5,
  split_var_bg = "darkgreen",
  split_var_fontsize = 5,
  Col_Prox_palette = "RdBu",
  Col_Prox_n_colors = 11,
  label_map = NULL,
  label_map_colors = NULL,
  type_palette = "Dark2",
  label_palette = "OrRd",
  n_label_color = 9,
  pred_ha_gap = unit(1, "mm"),
  prop_palette = gray,
  n_prop_colors = 11,
  Row_Prox_palette = "Spectral",
  Row_Prox_n_colors = 11,
  row_border = TRUE,
  row_gap = unit(1, "mm"),
  sorted_dat_palette = "Blues",
  sorted_dat_n_colors = 9,
  show_row_names = TRUE,
  row_names_gp = gpar(fontsize = 5),
  show_row_prox = TRUE,
  show_col_prox = TRUE,
  raw_value_col = NULL,
  lgd_direction = c("vertical", "horizontal"),
  x_eval_start = 15,
  y_eval_start = NULL,
  eval_text = 7,
  print_eval = TRUE,
  simple_metrics = FALSE
)
}
\arguments{
\item{x}{Character. Name or label of the dataset.}

\item{target_lab}{Character. Name of the target column.}

\item{show}{Character. Which subset to show: \code{"all"}, \code{"train"},
or \code{"test"}.}

\item{tree_index}{Integer. Which tree to extract (1-based). Default is 1.}

\item{ntree}{Integer. Number of trees in the forest (default 500).}

\item{mtry}{Integer or NULL. Number of variables randomly sampled at each
split. If NULL, uses the \code{cforest} default.}

\item{rf_control}{A \code{ctree_control} object or NULL.}

\item{data_train}{Data frame. Training data.}

\item{data_test}{Data frame. Test data.}

\item{data_all}{Data frame. Full dataset.}

\item{test_size}{Numeric. Proportion for test split (default 0.3).}

\item{task}{Character. \code{"classification"} or \code{"regression"}.}

\item{trans_type}{Character. Transformation type.}

\item{col_proximity}{Character. Correlation method.}

\item{linkage_method}{Character. Linkage method.}

\item{seriate_method}{Character. Seriation method.}

\item{cRGAR_w}{Integer. Window size for RGAR.}

\item{sort_by_data_type}{Logical. Preserve data_type grouping.}

\item{custom_layout}{Optional custom node positions.}

\item{panel_space}{Numeric. Vertical spacing.}

\item{margin}{Numeric. Margin in mm.}

\item{total_w}{Numeric. Page width in mm.}

\item{total_h}{Numeric. Page height in mm.}

\item{tree_p}{Numeric. Tree panel proportion.}

\item{include_var_imp}{Logical. Show importance barplot.}

\item{col_var_imp}{Color for importance bars.}

\item{var_imp_bar_width}{Numeric. Bar width.}

\item{var_imp_fontsize}{Numeric. Font size for importance.}

\item{split_var_bg}{Background for split variable names.}

\item{split_var_fontsize}{Font size for split variable names.}

\item{Col_Prox_palette}{Palette for correlation heatmap.}

\item{Col_Prox_n_colors}{Number of correlation colors.}

\item{label_map}{Named vector for label mapping.}

\item{label_map_colors}{Named vector of mapped label colors.}

\item{type_palette}{Palette for data_type.}

\item{label_palette}{Palette for labels.}

\item{n_label_color}{Number of label colors.}

\item{pred_ha_gap}{Gap between annotations.}

\item{prop_palette}{Probability gradient palette.}

\item{n_prop_colors}{Number of probability colors.}

\item{Row_Prox_palette}{Palette for row proximity.}

\item{Row_Prox_n_colors}{Number of row proximity colors.}

\item{row_border}{Draw cell borders.}

\item{row_gap}{Gap between annotation blocks.}

\item{sorted_dat_palette}{Palette for heatmap.}

\item{sorted_dat_n_colors}{Number of heatmap colors.}

\item{show_row_names}{Show row names.}

\item{row_names_gp}{Font settings for row names.}

\item{show_row_prox}{Show row proximity.}

\item{show_col_prox}{Show column proximity.}

\item{raw_value_col}{Colors for raw data values.}

\item{lgd_direction}{Legend direction.}

\item{x_eval_start}{Eval text x position.}

\item{y_eval_start}{Eval text y position.}

\item{eval_text}{Eval text font size.}

\item{print_eval}{Show evaluation results.}

\item{simple_metrics}{Use simple metrics.}
}
\value{
Draws the dtGAP visualization for the selected tree to the current
graphics device. Called for its side effect; returns invisibly.
}
\description{
Fits a \code{partykit::cforest} and visualizes one of its individual trees
using the full dtGAP pipeline (decision tree + heatmap + evaluation).
}
\examples{
\donttest{
rf_dtGAP(
  data_train = train_covid,
  data_test = test_covid,
  target_lab = "Outcome",
  show = "test",
  tree_index = 1,
  ntree = 50,
  print_eval = FALSE
)
}
}
