% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmerSLMADS2.R
\name{glmerSLMADS2}
\alias{glmerSLMADS2}
\title{Fitting generalized linear mixed effect models - serverside function}
\usage{
glmerSLMADS2(
  formula,
  offset,
  weights,
  dataName,
  family,
  control_type = NULL,
  control_value.transmit = NULL,
  nAGQ = 1L,
  verbose = 0,
  theta = NULL,
  fixef = NULL
)
}
\arguments{
\item{formula}{see help for ds.glmerSLMA}

\item{offset}{see help for ds.glmerSLMA}

\item{weights}{see help for ds.glmerSLMA}

\item{dataName}{see help for ds.glmerSLMA}

\item{family}{see help for ds.glmerSLMA}

\item{control_type}{see help for ds.glmerSLMA}

\item{control_value.transmit}{see help for argument <control_value> for
function ds.glmerSLMA}

\item{nAGQ}{integer scalar, defaulting to 1L. IN PRACTICE, IT MAY BE NECESSARY
TO SET nAGQ TO 0L when the model appears to converge perfectly well (e.g. verbose=2
demonstrates good initial convergence of both the log-likelihood and
regression coefficients) but formal convergence does not get declared - 
so no output is produced - despite running the model for many iterations.
The nAGQ argument is set by the nAGQ argument for ds.glmerSLMA and further
details can be found in help(ds.glmerSLMA) and in the native R help for glmer()}

\item{verbose}{see help for ds.glmerSLMA}

\item{theta}{see help for argument <start_theta> for
function ds.glmerSLMA}

\item{fixef}{see help for argument <start_fixef> for
function ds.glmerSLMA}
}
\value{
all key model components see help for ds.glmerSLMA
}
\description{
glmerSLMADS2 fits a generalized linear mixed effects model
(glme) - e.g. a logistic or Poisson regression model including both fixed and random effects
- on data from one or multiple sources with pooling via SLMA (study level meta-analysis)
}
\details{
glmerSLMADS2 is a serverside function called by ds.glmerSLMA on the clientside.
The analytic work engine is the glmer function in R which sits in the lme4 package.
ds.glmerSLMA fits a generalized linear mixed effects model (glme) - e.g. a logistic or
Poisson regression model including both fixed and random effects - on data
from a single or multiple sources. When there are multiple data sources,
the glme is fitted to convergence in each data source independently and the
estimates and standard errors returned to the client thereby enabling cross-study pooling
using study level meta-analysis (SLMA). By default the SLMA is undertaken
using the metafor package, but as the SLMA occurs on the clientside which, as far
as the user is concerned is just a standard R environment, the user can choose to use
any approach to meta-analysis they choose. Additional information about fitting 
glmes using the glmer engine can be obtained using R help for glmer and the lme4 package
}
\author{
Tom Bishop, with some additions by Paul Burton
}
