% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_in_shiny_app.R
\name{run_in_shiny_app}
\alias{run_in_shiny_app}
\title{Run a command against a running Shiny application}
\usage{
run_in_shiny_app(app_expr, port = 9999, timeout = 120, ...)
}
\arguments{
\item{app_expr}{A character string containing an R expression to launch
the Shiny app, executed via \code{Rscript -e}. The expression must start
the app on the specified \code{port}
(e.g. \code{"shiny::runApp('app/', port = 9999)"}).}

\item{port}{HTTP port used by the Shiny app. Default is \code{9999}.}

\item{timeout}{Maximum number of seconds to wait for the app to be
ready. Default is \code{120}.}

\item{...}{Arguments passed to \code{\link[processx:run]{processx::run()}}. At minimum,
\code{command} must be provided.}
}
\value{
The value returned by \code{\link[processx:run]{processx::run()}} (a list with
\code{status}, \code{stdout}, \code{stderr}, \code{timeout}).
}
\description{
Starts a Shiny app in a background process, waits for it
to be ready, executes an arbitrary command via \code{\link[processx:run]{processx::run()}},
and stops the app on exit.
}
\examples{
\dontrun{
res <- run_in_shiny_app(
  app_expr = "shiny::runApp('app/', port = 9999)",
  command = "npm", args = c("run", "scenario", "import-flow"),
  wd = tempdir()
)
}
}
