% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_snapshot_doc.R
\name{expect_snapshot_doc}
\alias{expect_snapshot_doc}
\title{Visual test for document}
\usage{
expect_snapshot_doc(
  name,
  x,
  tolerance = 0.001,
  engine = c("tinytest", "testthat")
)
}
\arguments{
\item{name}{a string to identify the test. Each document in the test suite must have a unique name.}

\item{x}{file path of a document}

\item{tolerance}{the ratio of different pixels that is acceptable before triggering a failure.}

\item{engine}{test package being used in the test suite, one of "tinytest" or "testthat".}
}
\value{
A \code{\link[tinytest:tinytest]{tinytest::tinytest()}} or a \link[testthat:expect_snapshot_file]{testthat::expect_snapshot_file} object.
}
\description{
This expectation can be used with 'tinytest' and 'testthat'
to check if a current document of type pdf, docx, doc, rtf, pptx or png
matches a target document. When the expectation is checked
for the first time, the expectation fails and a target miniature
of the document is saved in a folder named \verb{_tinytest_doconv} or
\verb{_snaps}.
}
\examples{
file <- system.file(package = "doconv",
  "doc-examples/example.docx")
\dontrun{
if (require("tinytest") && msoffice_available()){
  # first run add a new snapshot
  expect_snapshot_doc(x = file, name = "docx file", engine = "tinytest")
  # next runs compare with the snapshot
  expect_snapshot_doc(x = file, name = "docx file", engine = "tinytest")

  # cleaning directory
  unlink("_tinytest_doconv", recursive = TRUE, force = TRUE)
}
if (require("testthat") && msoffice_available()){
  local_edition(3)
  # first run add a new snapshot
  expect_snapshot_doc(x = file, name = "docx file", engine = "testthat")
  # next runs compare with the snapshot
  expect_snapshot_doc(x = file, name = "docx file", engine = "testthat")
}
}
}
