% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_quantile.R
\name{eval_quantile}
\alias{eval_quantile}
\alias{enframe_quantile}
\title{Distribution Quantiles}
\usage{
eval_quantile(distribution, at)

enframe_quantile(..., at, arg_name = ".arg", fn_prefix = "quantile", sep = "_")
}
\arguments{
\item{distribution, ...}{A distribution, or possibly multiple
distributions in the case of \code{...}.}

\item{at}{Vector of values to evaluate the representation at.}

\item{arg_name}{For \code{enframe_}, name of the column containing
the function arguments. Length 1 character vector.}

\item{fn_prefix}{For \code{enframe_}, name of the function to
appear in the column(s). Length 1 character vector.}

\item{sep}{When \code{enframe}'ing more than one distribution, the
character that will be separating the \code{fn_name} and the distribution name.
Length 1 character vector.}
}
\value{
The evaluated representation in vector form (for \code{eval_})
with length matching the length of \code{at}, and data frame
or tibble form (for \code{enframe_}) with number of rows matching the
length of \code{at}. The \code{at} input occupies the first column,
named \code{.arg} by default, or the specification in \code{arg_name};
the evaluated representations for each distribution in \code{...}
go in the subsequent columns (one column per distribution). For a
single distribution, this column is named according to the
representation by default (cdf, survival, quantile, etc.),
or the value in \code{fn_prefix}. For multiple distributions, unnamed
distributions are auto-named, and columns are named
\verb{<fn_prefix><sep><distribution_name>} (e.g., \code{cdf_distribution1}).
}
\description{
Access a distribution's quantiles.
}
\details{
When a quantile function does not exist, an algorithm is
deployed that calculates the left inverse of the CDF. This algorithm
works by progressively cutting the specified range in half, moving
into the left or right half depending on where the solution is.
The algorithm is not currently fast and is subject to improvement,
and is a simple idea that has been passed around on the internet
here and there. Tolerance is less than 1e-9, unless the maximum
number of iterations (200) is reached.

The algorithm is not new, and is rather simple.
The algorithm works by progressively
cutting an initially wide range in half, moving into the left or right
half depending on where the solution is. I found the idea on Stack
Overflow somewhere, but unfortunately cannot find the location anymore.
}
\examples{
d <- dst_unif(0, 4)
eval_quantile(d, at = 1:9 / 10)
enframe_quantile(d, at = 1:9 / 10)
}
\seealso{
Other distributional representations: 
\code{\link{eval_cdf}()},
\code{\link{eval_chf}()},
\code{\link{eval_density}()},
\code{\link{eval_hazard}()},
\code{\link{eval_odds}()},
\code{\link{eval_pmf}()},
\code{\link{eval_return}()},
\code{\link{eval_survival}()}
}
\concept{distributional representations}
