% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disclapmix2.R, R/zzz.R
\docType{package}
\name{disclapmix2}
\alias{disclapmix2}
\title{Discrete Laplace mixture inference using Numerical Optimisation}
\usage{
disclapmix2(
  x,
  number_of_clusters,
  include_2_loci = FALSE,
  remove_non_standard_haplotypes = TRUE,
  use_stripped_data_for_initial_clustering = FALSE,
  initial_y_method = "pam",
  verbose = 0L
)
}
\arguments{
\item{x}{DataFrame. Columns should be one character vector for each locus}

\item{number_of_clusters}{The number of clusters to fit the model for.}

\item{include_2_loci}{Should duplicated loci be included or excluded from the analysis?}

\item{remove_non_standard_haplotypes}{Should observations that are not single integer alleles be removed?}

\item{use_stripped_data_for_initial_clustering}{Should non_standard data be removed for the initial clustering?}

\item{initial_y_method}{Which cluster method to use for finding initial central haplotypes, y: pam (recommended) or clara.}

\item{verbose}{Set to 1 (or higher) to print optimisation details. Default is 0.}
}
\value{
List.
}
\description{
An extension to the *disclapmix* method in the *disclapmix* package that supports duplicated loci and other non-standard haplotypes.

Description of your package
}
\examples{
require(disclapmix)

data(danes) 

x <- as.matrix(danes[rep(seq_len(nrow(danes)), danes$n), -ncol(danes)])
x2 <- as.data.frame(sapply(danes[rep(seq_len(nrow(danes)), danes$n), -ncol(danes)], as.character))


dlm_fit <- disclapmix(x, clusters = 3L)
dlm2_fit <- disclapmix2(x2, number_of_clusters = 3)

stopifnot(all.equal(dlm_fit$logL_marginal, dlm2_fit$log_lik))
}
\author{
you
}
