% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{loo_indiv}
\alias{loo_indiv}
\alias{looi_disbayes}
\title{Extract observation-specific contributions from a disbayes leave-one-out cross validation}
\usage{
loo_indiv(x, agg = FALSE)

looi_disbayes(x, agg = FALSE)
}
\arguments{
\item{x}{For \code{loo_indiv}, an object returned by \code{\link{loo.disbayes}}.   For \code{looi_disbayes}, an object returned by \code{\link{disbayes}}.}

\item{agg}{If \code{TRUE} then the observation-specific contributions are aggregated over
outcome type, returning a data frame with one row for each of incidence, prevalence, mortality
and remission (if remission is included in the model), and one column for each of \code{"elpd_loo"},
\code{"p_loo"} and \code{"looic"}.}
}
\value{
A data frame with one row per observed age-specific mortality, incidence, prevalence and/or
remission age-specific data-point, containing leave-one-out cross validation statistics representing how
well the model would predict that observation if it were left out of the fit. 

These are computed with the \pkg{loo} package.

\code{loo_indiv} acts on the objects that are returned by running \code{\link{loo}} on \code{\link{disbayes}}
objects.  \code{\link{looi_disbayes}} acts directly on  \code{\link{disbayes}}
objects.  Both of those functions return a data frame with LOO contributions for each data point.
}
\description{
Extract observation-specific contributions from a disbayes leave-one-out cross validation
}
\section{Functions}{
\itemize{
\item \code{looi_disbayes()}: Observation-level leave-one-out cross validation statistics for a disbayes model

}}
