% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import_rivers}
\alias{import_rivers}
\title{Prepare rivers for connectivity analyses}
\usage{
import_rivers(rivers, quiet = FALSE)
}
\arguments{
\item{rivers}{A character string specifying the path to a shapefile of river lines,
or an \code{sf} object representing river geometries.}

\item{quiet}{Logical. If \code{FALSE} (default), plots the imported river lines in
black over the original lines in red so that removed rivers are highlighted.}
}
\value{
An object of class \code{rivers}, suitable for use with \code{\link[=enforce_dendritic]{enforce_dendritic()}}
or as input to \code{\link[=river_net]{river_net()}}.
}
\description{
Reads and prepares geospatial river line data for use in \code{\link[=river_net]{river_net()}}.
Only the largest fully connected component of the network is retained;
river lines that are part of disconnected secondary networks are discarded.
}
\examples{
rivers_in <- import_rivers(yamaska_rivers)

# This can also be done quietly to omit plotting river lines after importing
rivers_in <- import_rivers(yamaska_rivers, quiet = TRUE)
}
