% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_lm.R
\name{reg_lm}
\alias{reg_lm}
\title{Linear regression (lm)}
\usage{
reg_lm(formula = NULL, attribute = NULL, features = NULL)
}
\arguments{
\item{formula}{optional regression formula (e.g., y ~ x1 + x2).}

\item{attribute}{target attribute name (used when formula is NULL)}

\item{features}{optional vector of feature names (used when formula is NULL)}
}
\value{
returns a \code{reg_lm} object
}
\description{
Linear regression using \code{stats::lm}.
}
\examples{
if (requireNamespace("MASS", quietly = TRUE)) {
 data(Boston, package = "MASS")

 # Simple linear regression
 model_simple <- reg_lm(formula = medv ~ lstat)
 model_simple <- fit(model_simple, Boston)
 pred_simple <- predict(model_simple, Boston)
 head(pred_simple)

 # Polynomial regression (degree 2)
 model_poly <- reg_lm(formula = medv ~ poly(lstat, 2, raw = TRUE))
 model_poly <- fit(model_poly, Boston)
 pred_poly <- predict(model_poly, Boston)
 head(pred_poly)

 # Multiple regression
 model_multi <- reg_lm(formula = medv ~ lstat + rm + ptratio)
 model_multi <- fit(model_multi, Boston)
 pred_multi <- predict(model_multi, Boston)
 head(pred_multi)
}
}
