% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_feature_selection_corr.R
\name{feature_selection_corr}
\alias{feature_selection_corr}
\title{Feature selection by correlation}
\usage{
feature_selection_corr(cutoff = 0.9)
}
\arguments{
\item{cutoff}{correlation cutoff in [0, 1] above which one feature is removed}
}
\value{
returns an object of class \code{feature_selection_corr}
}
\description{
Remove highly correlated numeric features based on a correlation cutoff.
}
\details{
Uses \code{caret::findCorrelation} on the correlation matrix computed from numeric columns.
}
\examples{
data(iris)
fs <- feature_selection_corr(cutoff = 0.9)
fs <- fit(fs, iris)
iris_fs <- transform(fs, iris)
names(iris_fs)
}
