% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{UScrimerates_tbl_df}
\alias{UScrimerates_tbl_df}
\title{US Crime Rates (1960–2019)}
\format{
A tibble with 60 rows and 12 variables:
\describe{
  \item{year}{Year of the recorded data (numeric).}
  \item{population}{Total US population (numeric).}
  \item{total}{Total number of crimes (numeric).}
  \item{violent}{Total number of violent crimes (numeric).}
  \item{property}{Total number of property crimes (numeric).}
  \item{murder}{Number of murders (numeric).}
  \item{forcible_rape}{Number of reported cases of forcible rape (numeric).}
  \item{robbery}{Number of robberies (numeric).}
  \item{aggravated_assault}{Number of aggravated assaults (numeric).}
  \item{burglary}{Number of burglaries (numeric).}
  \item{larceny_theft}{Number of larceny-theft crimes (numeric).}
  \item{vehicle_theft}{Number of motor vehicle thefts (numeric).}
}
}
\source{
National crime data for the United States (1960–2019).
}
\usage{
data(UScrimerates_tbl_df)
}
\description{
This dataset contains national data on the number of crimes committed in the United States between 1960 and 2019.
It provides annual statistics on total crimes, violent crimes, property crimes, and their subcategories.
}
\details{
The dataset name has been changed to 'UScrimerates_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix 'tbl_df'
indicates that the dataset is stored as a tibble. The original content has not been modified in any way.
}
