% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{NigeriaTerrorism_df}
\alias{NigeriaTerrorism_df}
\title{Nigeria Terrorism Data}
\format{
A data frame with 312 observations and 6 variables:
\describe{
  \item{att.ful}{Number of attacks by Fulani Extremists (numeric).}
  \item{att.bok}{Number of attacks by Boko Haram (numeric).}
  \item{xcoord}{X-coordinate of the attack location (numeric).}
  \item{ycoord}{Y-coordinate of the attack location (numeric).}
  \item{pop}{Population of the area (numeric).}
  \item{mtns}{Indicator of whether the location is mountainous (numeric).}
}
}
\source{
Global Terrorism Database and UCDP PRIO-Grid data.
}
\usage{
data(NigeriaTerrorism_df)
}
\description{
This dataset contains information on terrorist attacks by Fulani Extremists and Boko Haram in Nigeria,
starting from the year 2014. The attack data is sourced from the Global Terrorism Database, while other
variables are derived from the UCDP PRIO-Grid data. The dataset includes geographic coordinates,
population data, and information about mountainous areas relevant to the attacks.
}
\details{
The dataset name has been changed to 'NigeriaTerrorism_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix
'df' indicates that the dataset is a traditional data frame in R. The original content has not been modified
in any way.
}
