% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_propensity.R
\name{ps_match}
\alias{ps_match}
\title{Propensity Score Matching}
\usage{
ps_match(
  formula = NULL,
  data = NULL,
  treatment = NULL,
  ps_model = NULL,
  caliper_sd = 0.2,
  method = "auto",
  replace = FALSE,
  ratio = 1L,
  ...
)
}
\arguments{
\item{formula}{Formula for propensity score model (treatment ~ covariates).
Required if \code{ps_model} is NULL.}

\item{data}{Combined dataset containing both treated and control units}

\item{treatment}{Name of the binary treatment column (0/1 or logical)}

\item{ps_model}{Pre-fitted \code{glm} object (alternative to formula).
If provided, \code{formula} is ignored.}

\item{caliper_sd}{Caliper width in standard deviations of logit(PS).
Default: 0.2 (Rosenbaum and Rubin recommendation).}

\item{method}{LAP solver method (default: "auto")}

\item{replace}{If TRUE, match with replacement (default: FALSE)}

\item{ratio}{Integer k for k:1 matching (default: 1)}

\item{...}{Additional arguments passed to \code{\link[=match_couples]{match_couples()}}}
}
\value{
A matching_result object with additional propensity score info
in \code{result$info$ps_model} and \code{result$info$caliper_value}.
}
\description{
Matches treated and control units based on estimated propensity scores.
Fits a logistic regression model (or accepts a pre-fitted one), computes
logit propensity scores, and calls \code{\link[=match_couples]{match_couples()}} with a caliper on
the logit scale.
}
\details{
The propensity score is the probability of treatment assignment conditional
on observed covariates. Matching is performed on the logit of the propensity
score (Rosenbaum and Rubin 1985), which provides better distributional
properties than matching on the raw probability scale.

The default caliper of 0.2 SD of logit(PS) is recommended by Austin (2011)
as removing approximately 98\% of bias.
}
\examples{
set.seed(42)
n <- 100
data <- data.frame(
  id = seq_len(n),
  treated = rbinom(n, 1, 0.4),
  age = rnorm(n, 50, 10),
  income = rnorm(n, 50000, 15000)
)
result <- ps_match(treated ~ age + income, data = data, treatment = "treated")
print(result)

}
