% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_core.R
\name{.couples_single}
\alias{.couples_single}
\title{Shared single matching implementation}
\usage{
.couples_single(
  left,
  right,
  left_ids,
  right_ids,
  vars,
  distance,
  weights,
  scale,
  max_distance,
  calipers,
  solver_fn,
  solver_params = list(),
  check_costs = FALSE,
  strict_no_pairs = FALSE,
  replace = FALSE,
  ratio = 1L
)
}
\arguments{
\item{solver_fn}{Solver function (assignment or greedy_matching)}

\item{solver_params}{Named list of extra args passed to solver_fn}

\item{check_costs}{If TRUE, run check_cost_distribution before solving}

\item{strict_no_pairs}{If TRUE, call err_no_valid_pairs (stops); else warn}
}
\value{
List with pairs tibble, unmatched list, and info list.
}
\description{
Core logic for both optimal (LAP) and greedy matching without blocking.
Called by match_couples_single() and greedy_couples_single().
}
\keyword{internal}
