% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_core.R
\name{.couples_from_distance}
\alias{.couples_from_distance}
\title{Shared matching from precomputed distance object}
\usage{
.couples_from_distance(
  dist_obj,
  max_distance = Inf,
  calipers = NULL,
  ignore_blocks = FALSE,
  require_full_matching = FALSE,
  return_unmatched = TRUE,
  return_diagnostics = FALSE,
  solver_fn,
  solver_params = list(),
  check_costs = FALSE,
  strict_no_pairs = FALSE,
  method_label = "from_distance_object",
  extra_info = list(),
  diagnostics_fields = c("method", "n_matched", "total_distance")
)
}
\arguments{
\item{solver_fn}{Solver function (assignment or greedy_matching)}

\item{solver_params}{Named list of extra args passed to solver_fn}

\item{check_costs}{If TRUE, run check_cost_distribution before solving}

\item{strict_no_pairs}{If TRUE, call err_no_valid_pairs (stops); else warn}

\item{method_label}{String for info$method (e.g., "from_distance_object")}

\item{extra_info}{Named list of extra fields to add to info}
}
\value{
A matching_result object with pairs, info, and optional diagnostics.
}
\description{
Core logic for both optimal (LAP) and greedy matching from distance objects.
Called by match_couples_from_distance() and greedy_couples_from_distance().
}
\keyword{internal}
