% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_plots.R
\name{autoplot.balance_diagnostics}
\alias{autoplot.balance_diagnostics}
\title{ggplot2 autoplot for balance diagnostics}
\usage{
\method{autoplot}{balance_diagnostics}(
  object,
  type = c("love", "histogram", "variance"),
  threshold = 0.1,
  ...
)
}
\arguments{
\item{object}{A balance_diagnostics object}

\item{type}{Type of plot: "love" (default), "histogram", or "variance"}

\item{threshold}{Threshold for standardized differences (default: 0.1)}

\item{...}{Additional arguments (ignored)}
}
\value{
A ggplot object
}
\description{
Produces ggplot2-based balance assessment plots. Returns a ggplot object.
}
\examples{
\donttest{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  set.seed(42)
  left <- data.frame(id = 1:10, age = rnorm(10, 45, 10),
                     income = rnorm(10, 50000, 15000))
  right <- data.frame(id = 11:30, age = rnorm(20, 47, 10),
                       income = rnorm(20, 52000, 15000))
  result <- match_couples(left, right, vars = c("age", "income"))
  bal <- balance_diagnostics(result, left, right, vars = c("age", "income"))
  ggplot2::autoplot(bal)
}
}

}
