% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{create_contoso_duckdb}
\alias{create_contoso_duckdb}
\title{Creates DuckDB database with Contoso datasets}
\usage{
create_contoso_duckdb(size = "small")
}
\arguments{
\item{size}{Dataset size: "small", "medium", "large", or "mega"}
}
\value{
A list containing:
\itemize{
\item \code{sales}, \code{product}, \code{customer}, \code{store}, \code{fx}, \code{calendar}, \code{orders}, \code{orderrows}: lazy \code{tbl} objects
\item \code{con}: the DuckDB connection (use \code{DBI::dbDisconnect(db$con, shutdown = TRUE)} when done)
}
}
\description{
Creates a DuckDB connection with Contoso datasets loaded from cloud storage.
The datasets are stored as Parquet files on Cloudflare R2 and streamed directly
into DuckDB.
}
\details{
The \code{create_contoso_duckdb()} function creates views for the following Contoso datasets:
\itemize{
\item \code{sales}: Contains sales transaction data.
\item \code{product}: Contains details about products, including attributes like product name, manufacturer, and category.
\item \code{customer}: Contains customer demographic and geographic information.
\item \code{store}: Contains information about store locations and attributes.
\item \code{fx}: Contains foreign exchange rate data for currency conversion.
\item \code{calendar}: Contains various date-related information, including day, week, month, and year.
\item \code{orders}: Contains order header information.
\item \code{orderrows}: Contains order line items.
}

Available sizes (approximate sales rows):
\itemize{
\item \code{small}: ~8,000 rows
\item \code{medium}: ~2.3 million rows
\item \code{large}: ~47 million rows
\item \code{mega}: ~237 million rows
}
}
\examples{
\dontrun{
  db <- create_contoso_duckdb(size = "small")
  db$sales |> head()
  DBI::dbDisconnect(db$con, shutdown = TRUE)
}
}
