% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-accounts.R
\name{connect_workload_token}
\alias{connect_workload_token}
\alias{has_workload_token}
\title{Workload identity tokens on Posit Connect}
\usage{
connect_workload_token(
  ...,
  content_token = Sys.getenv("CONNECT_CONTENT_SESSION_TOKEN"),
  server_url = Sys.getenv("CONNECT_SERVER"),
  api_key = Sys.getenv("CONNECT_API_KEY")
)

has_workload_token(...)
}
\arguments{
\item{...}{Further arguments passed on to \code{\link[=connect_workload_token]{connect_workload_token()}}.}

\item{content_token}{A token that uniquely identifies this content session.
Defaults to the value of the \code{CONNECT_CONTENT_SESSION_TOKEN} environment
variable, which is set automatically when running on Connect.}

\item{server_url}{The Connect server to exchange credentials with. Defaults
to the value of the \code{CONNECT_SERVER} environment variable, which is set
automatically when running on Connect.}

\item{api_key}{An API key for the Connect server. Defaults to the value of
the \code{CONNECT_API_KEY} environment variable, which is set automatically when
running on Connect.}
}
\value{
\code{\link[=connect_workload_token]{connect_workload_token()}} returns an \link[httr2:oauth_token]{httr2::oauth_token}.

\code{\link[=has_workload_token]{has_workload_token()}} returns \code{TRUE} if a workload identity token
is available and \code{FALSE} otherwise.
}
\description{
Request an OpenID Connect identity token suitable for workload identity
federation with a third-party service.
}
\details{
\code{connect_workload_token()} handles caching automatically.
}
\examples{
integration_guid <- "891db041-22d6-4f5f-9fee-fc715a33929e"
token <- "default-token"
if (has_workload_token(audience = integration_guid)) {
  token <- connect_workload_token(audience = integration_guid)
}
}
