% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genIndepDepJson.R
\name{genIndepDepJson}
\alias{genIndepDepJson}
\title{Generate Body for the POST Function of Uncovr}
\usage{
genIndepDepJson(numOfObs, numOfVars, modelObj)
}
\arguments{
\item{numOfObs}{A number. This represents the number of observations in the data. In other words, the number of rows of data that are requested to be generated. The \emph{numOfObs} argument must be a non-negative integer.}

\item{numOfVars}{A number. This represents the number of variables in the data. In other words, the number of columns of data that are requested to be generated. The \emph{numOfVars} argument must be a non-negative integer.}

\item{modelObj}{An optional argument. An lm or glm model object. The current limitation is that the independent and dependent variables must be continuous.}
}
\value{
A json with the details of independent variable and the dependent variable. The format of this json is as required by the \emph{uncovr} api end point.
}
\description{
This is an internal function used by \code{\link{buildModelData}} function.
}
\details{
This function is one of the core functions for the generation of data that comprises of independent and dependent variables. The purpose of this function can be best understood when explained within the context that is given below. There is a proprietary SaaS(Software as a Service) software named \emph{uncovr} that provides an API(Application Programming Interface). In its current state, the SaaS software is free to use with some constraints around the volume of data and the frequency of API calls. One of the functions of \emph{uncovr} API takes is to source inputs such as number of observations i.e. rows and number of independent variables namely columns and gives an output. The input of the \emph{uncovr} function is required to be sent as part of the body of the html POST functionality. This function \emph{genIndepDepJson} creates the json in the form required by \emph{uncovr} API.
As an optional argument, an lm or glm model object can be passed using the \emph{modelObj} argument. This will ensure that the coefficients of the independent variables are sourced from the model object instead of generating  randomly by the \emph{uncovr} API. The current limitation is that the independent and dependent variables must be continuous.
}
