% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_palette.R
\name{make_palette}
\alias{make_palette}
\title{Create a color palette from an image.}
\usage{
make_palette(
  data,
  n = 10,
  clust_method = "kmeans",
  extract_method = "hex_freq",
  show = TRUE
)
}
\arguments{
\item{data}{a \code{data.frame} from a \code{get_colors} call consisting of the columns \code{col_hex}, \code{col_freq},
\code{col_share}.}

\item{n}{the number of discrete colors to be extracted from the data.}

\item{clust_method}{specifies the method used to cluster the pixels. By default, the colors are clustered by the
\code{\link[stats:kmeans]{k-means}} method. Alternatively, a \href{https://en.wikipedia.org/wiki/Median_cut}{median cut}
approach \code{"median_cut"} can be used.}

\item{extract_method}{specifies the process for extracting the colors from the clusters obtained. By default \code{"hex_freq"},
the most common hex colors per cluster are returned. Alternatively, the cluster-specific\code{"mean"}, \code{"median"} or
\code{"mode"} of the RGB values can be used to define the desired number of hex colors.}

\item{show}{by default \code{"TRUE"}, the generated color palette is displayed.}
}
\value{
A character vector with hex color codes, sorted by the weight of the associated clusters.
}
\description{
\code{make_palette} creates a color palette from colors extracted from Windows BMP, JPEG, PNG, TIFF, and SVG format images with
    the \code{get_colors} function.
}
\examples{
# Create palette from image
img <- system.file("extdata", "pic6.png", package = "colorfindr")
colors <- get_colors(img)
make_palette(colors)

}
