% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{colored_multi_rnorm}
\alias{colored_multi_rnorm}
\title{Generate Multiple Cross-Correlated & Autocorrelated Variables}
\usage{
colored_multi_rnorm(timesteps, mean, sd, phi, covMatrix)
}
\arguments{
\item{timesteps}{The number of temporally autocorrelated random numbers (one
per timestep) you want.}

\item{mean}{A vector giving the mean of each variable.}

\item{sd}{A vector giving the standard deviation of each variable.}

\item{phi}{A vector giving the temporal autocorrelation of each variable.}

\item{covMatrix}{A valid covariance matrix. The number of rows/columns must match the length of the mu, sigma, and phi vectors.}
}
\value{
A matrix with as many rows as timesteps and as many columns as mu/sigma/phi values.
}
\description{
Generates random variables that are correlated to each other and temporally autocorrelated.
}
\examples{
cov <- matrix(c(1, 0.53, 0.73, 0.53, 1, 0.44, 0.73, 0.44, 1), nrow = 3)
test <- colored_multi_rnorm(100, c(0, 3, 5), c(1, 0.5, 1), c(0.5, -0.3, 0), cov)
var(test)
library(data.table)
as.data.table(test)[, .(V1_mean = mean(V1), V2_mean = mean(V2), V3_mean = mean(V3),
V1_sd = sd(V1), V2_sd = sd(V2), V3_sd = sd(V3),
V1_autocorrelation = autocorrelation(V1), V2_autocorrelation = autocorrelation(V2),
V3_autocorrelation = autocorrelation(V3))]
}
