% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-network.R
\name{set_edges}
\alias{set_edges}
\title{Set Edges in Cograph Network}
\usage{
set_edges(x, edges_df)
}
\arguments{
\item{x}{A cograph_network object.}

\item{edges_df}{A data frame with columns: from, to, and optionally weight.}
}
\value{
The modified cograph_network object.
}
\description{
Replaces the edges in a cograph_network object.
Expects a data frame with from, to, and optionally weight columns.
Updates the from, to, weight vectors and n_edges.
}
\examples{
mat <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
net <- as_cograph(mat)
new_edges <- data.frame(from = c(1, 2), to = c(2, 3), weight = c(0.5, 0.8))
net <- set_edges(net, new_edges)
get_edges(net)
}
\seealso{
\code{\link{as_cograph}}, \code{\link{get_edges}}, \code{\link{set_nodes}}
}
