% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes-svg.R
\name{register_svg_shape}
\alias{register_svg_shape}
\title{Register Custom SVG Shape}
\usage{
register_svg_shape(name, svg_source)
}
\arguments{
\item{name}{Character: unique name for this shape (used in node_shape parameter).}

\item{svg_source}{Character: path to SVG file OR inline SVG string.}
}
\value{
Invisible NULL. The shape is registered for use with sn_nodes().
}
\description{
Register an SVG file or string as a custom node shape.
}
\examples{
# Register a custom SVG shape from an inline SVG string
register_svg_shape("simple_star",
  '<svg viewBox="0 0 100 100">
    <polygon points="50,5 20,99 95,39 5,39 80,99" fill="currentColor"/>
  </svg>')

# Create a small adjacency matrix
adj <- matrix(c(0, 1, 1, 0, 0, 1, 1, 0, 0), nrow = 3,
              dimnames = list(c("A", "B", "C"), c("A", "B", "C")))

# Use in network (requires grImport2 for SVG rendering; falls back to circle)
cograph(adj) |> sn_nodes(shape = "simple_star")
}
