% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-circle.R
\name{layout_circle}
\alias{layout_circle}
\title{Circular Layout}
\usage{
layout_circle(network, order = NULL, start_angle = pi/2, clockwise = TRUE)
}
\arguments{
\item{network}{A CographNetwork object.}

\item{order}{Optional vector specifying node order (indices or labels).}

\item{start_angle}{Starting angle in radians (default: pi/2 for top).}

\item{clockwise}{Logical. Arrange nodes clockwise? Default TRUE.}
}
\value{
Data frame with x, y coordinates.
}
\description{
Arrange nodes evenly spaced around a circle.
}
\examples{
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
net <- CographNetwork$new(adj)
coords <- layout_circle(net)
}
