% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cograph-package.R
\docType{package}
\name{cograph-package}
\alias{cograph-package}
\title{cograph: Modern Network Visualization}
\description{
A modern, extensible network visualization package that provides high-quality
static and interactive network plots. cograph accepts adjacency matrices,
edge lists, or igraph objects and offers customizable layouts, node shapes,
edge styles, and themes.
}
\section{Main Functions}{

\itemize{
\item \code{\link{cograph}}: Main entry point for creating network visualizations
\item \code{\link{sn_layout}}: Apply layout algorithms
\item \code{\link{sn_nodes}}: Customize node aesthetics
\item \code{\link{sn_edges}}: Customize edge aesthetics
\item \code{\link{sn_theme}}: Apply visual themes
\item \code{\link{sn_render}}: Render to device
\item \code{\link{sn_ggplot}}: Convert to ggplot2 object
}
}

\section{Layouts}{

cograph provides several built-in layouts:
\itemize{
\item \code{circle}: Nodes arranged in a circle
\item \code{spring}: Fruchterman-Reingold force-directed layout
\item \code{groups}: Group-based circular layout
\item \code{custom}: User-provided coordinates
}
}

\section{Themes}{

Built-in themes include:
\itemize{
\item \code{classic}: Traditional network visualization style
\item \code{colorblind}: Accessible color scheme
\item \code{gray}: Grayscale theme
\item \code{dark}: Dark background theme
\item \code{minimal}: Clean, minimal style
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://sonsoles.me/cograph/}
  \item Report bugs at \url{https://github.com/sonsoleslp/cograph/issues}
}

}
\author{
\strong{Maintainer}: Sonsoles López-Pernas \email{sonsoles.lopez@uef.fi}

Authors:
\itemize{
  \item Mohammed Saqr
  \item Santtu Tikka
}

}
\keyword{internal}
