% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splot-labels.R
\name{build_edge_labels_from_template}
\alias{build_edge_labels_from_template}
\title{Build Edge Labels from Template}
\usage{
build_edge_labels_from_template(
  template = NULL,
  style = "none",
  weights = NULL,
  ci_lower = NULL,
  ci_upper = NULL,
  p_values = NULL,
  stars = NULL,
  digits = 2,
  p_digits = 3,
  p_prefix = "p=",
  ci_format = "bracket",
  oneline = TRUE,
  n
)
}
\arguments{
\item{template}{Template string or NULL.}

\item{style}{Style preset (used if template is NULL).}

\item{weights}{Edge weights/estimates.}

\item{ci_lower}{Lower CI bounds (vector).}

\item{ci_upper}{Upper CI bounds (vector).}

\item{p_values}{P-values (vector).}

\item{stars}{Stars input (character vector, logical, or numeric p-values).}

\item{digits}{Decimal places for estimates.}

\item{p_digits}{Decimal places for p-values.}

\item{p_prefix}{Prefix for p-values.}

\item{ci_format}{CI format: "bracket" or "dash".}

\item{oneline}{Logical: single line format.}

\item{n}{Number of edges.}
}
\value{
Character vector of formatted labels.
}
\description{
Generates edge labels for all edges using template formatting.
}
\keyword{internal}
