% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em_algorithm.R
\name{calc_SE_rowcluster}
\alias{calc_SE_rowcluster}
\alias{calc_SE_bicluster}
\title{Calculate standard errors of clustering parameters.}
\usage{
calc_SE_rowcluster(long_df, clust_out, control_optim = default_control_optim())

calc_SE_bicluster(long_df, clust_out, control_optim = default_control_optim())
}
\arguments{
\item{long_df}{The data frame, in long format, as passed to \code{clustord}.}

\item{clust_out}{A \code{clustord} object.}

\item{control_optim}{control list for the \code{optim} call within the M step
of the EM algorithm. See the control list Details in the \code{optim}
manual for more info.}
}
\value{
The standard errors corresponding to the elements of \code{clust_out$out_parvec}.
}
\description{
Calculate SE of parameters fitted using \code{\link{clustord}}.
}
\details{
Use \code{calc_SE_rowcluster} to calculate SE for row clustering and column
clustering, or \code{calc_SE_bicluster} to calculate SE for biclustering.

Calculates SE by running \code{optimHess} (see \code{\link[stats]{optim}}) on
the incomplete-data log-likelihood to find the hessian at the fitted parameter
values from \code{\link{clustord}}.
Then the square roots of the diagonal elements of the negative inverse of the
hessian are the standard errors of the parameters
i.e. \code{SE <- sqrt(diag(solve(-optim_hess))}.

Note that SE values are \strong{only} calculated for the independent
parameters. For example, if the constraint on the row clustering parameters
is set to constraint_sum_zero = TRUE, where the last row clustering parameter
is the negative sum of the other parameters, SE values will only be
calculated for the first RG-1 parameters, the independent ones. This applies
similarly to individual column effect coefficients, etc.

The function requires an input which is the output of
\code{\link{clustord}}, which includes the component \code{out_parvec}, the
final vector of independent parameter values from the EM algorithm, which
will correspond to a subset of the parameter values in \code{out_parlist}.
}
\section{Functions}{
\itemize{
\item \code{calc_SE_rowcluster()}: SE for rowclustering

\item \code{calc_SE_bicluster()}: SE for biclustering

}}
