% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_study}
\alias{download_study}
\title{Download a Clinical Trial Study Dataset}
\usage{
download_study(
  source,
  version = "latest",
  force = FALSE,
  repo = "Lovemore-Gakava/clinTrialData"
)
}
\arguments{
\item{source}{Character string. The name of the study to download (e.g.
\code{"cdisc_pilot"}). Use \code{\link[=list_available_studies]{list_available_studies()}} to see all options.}

\item{version}{Character string. The release tag to download from. Defaults
to \code{"latest"}, which resolves to the most recent release.}

\item{force}{Logical. If \code{TRUE}, re-download even if the study is already
cached. Defaults to \code{FALSE}.}

\item{repo}{GitHub repository in the form \code{"owner/repo"}. Defaults to the
official \code{clinTrialData} release repository.}
}
\value{
Invisibly returns the path to the cached study directory.
}
\description{
Downloads a study dataset from a GitHub Release and stores it in the local
cache (see \code{\link[=cache_dir]{cache_dir()}}). Once downloaded, the study is available to
\code{\link[=connect_clinical_data]{connect_clinical_data()}} without an internet connection.

Requires the \code{piggyback} package.
}
\examples{
\donttest{
# Download the CDISC Pilot study
download_study("cdisc_pilot")

# Then connect as usual
db <- connect_clinical_data("cdisc_pilot")
}
}
