% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{connect_clinical_data}
\alias{connect_clinical_data}
\title{Connect to Clinical Data by Source}
\usage{
connect_clinical_data(source = "cdisc_pilot")
}
\arguments{
\item{source}{Character string specifying the data source.
Use \code{list_data_sources()} to see all available options.}
}
\value{
A \code{connectors} object
}
\description{
Generic connection function that allows access to any data source
in the package. Data sources are automatically discovered by scanning
the package's example data directory structure.
}
\examples{
\donttest{
# Connect to CDISC Pilot data
db <- connect_clinical_data("cdisc_pilot")

# List available datasets
db$adam$list_content_cnt()

# Read a dataset
adsl <- db$adam$read_cnt("adsl")

# List available sources
list_data_sources()
}
}
