% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepiweek.R
\name{cepiweek}
\alias{cepiweek}
\title{Generate Continuous Epidemiological Week Index for a Date Column}
\usage{
cepiweek(data, col_date, start = NULL)
}
\arguments{
\item{data}{A data frame containing the date column.}

\item{col_date}{Name of the date column (string).}

\item{start}{Optional start date for counting weeks (Date or string).
Defaults to the minimum date in the column \code{col_date}.}
}
\value{
A data frame with an added \code{cepiweek} column containing
continuous week indices.
}
\description{
This function adds a continuous epidemiological week index to a data frame
by assigning each date to a sequential week number starting from a reference
date.
}
\details{
The generated weeks do not reset at calendar year boundaries and are not ISO
8601 or MMWR weeks. You can specify the start date for week counting; if none
is provided, the minimum date in the column is used.

This design is intended for epidemiological modeling, time-series analysis,
and nowcasting applications.

\href{https://github.com/DeginaDaniel/cepiweek}{GitHub of the package}.
}
\examples{
k <- data.frame(
  num = c(1, 2, 3),
  date = c("2024-01-15", "2025-02-12", "2026-08-01")
)
cepiweek(k, col_date = "date")


}
