% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_ops_doc.R
\name{shift_left}
\alias{shift_left}
\title{Shift State Left (with Coordinates)}
\arguments{
\item{state}{Integer vector representing the current permutation state}

\item{coords}{Optional list of current celestial coordinates. If NULL,
starts from zero coordinates.}
}
\value{
List with components:
\item{state}{Integer vector with elements shifted left by one position}
\item{coords}{List of updated celestial coordinates (nL, nR, nX, theta, phi, omega_conformal)}
}
\description{
Performs a cyclic left shift on the state vector, moving the first element
to the end. Tracks celestial coordinates (LRX momentum).
}
\examples{
result <- shift_left(1:5)
result$state
result$coords

# Chain operations using coords
r1 <- shift_left(1:5)
r2 <- shift_left(r1$state, r1$coords)
r2$coords$nL
}
