% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reachable_states.R
\name{get_reachable_states}
\alias{get_reachable_states}
\title{Find Cycle in Permutation Group}
\usage{
get_reachable_states(start_state, allowed_positions, k, verbose = FALSE)
}
\arguments{
\item{start_state}{Integer vector, the initial permutation state}

\item{allowed_positions}{Character vector, sequence of operations to repeat}

\item{k}{Integer, parameter for reverse operations}

\item{verbose}{Logical; if TRUE, prints progress and cycle information (default FALSE)}
}
\value{
List containing:
\item{states}{List of all visited states}
\item{reachable_states_df}{Data frame with states, operations, steps, and celestial coordinates}
\item{operations}{Vector of operations applied}
\item{coords}{List of celestial coordinate objects per step}
\item{nL_total}{Total left shifts}
\item{nR_total}{Total right shifts}
\item{nX_total}{Total reverse operations}
\item{total_moves}{Total number of moves in the cycle}
\item{unique_states_count}{Number of unique states visited}
\item{cycle_info}{Summary string with cycle statistics}
}
\description{
Explores the Cayley graph starting from an initial state and applying
a sequence of operations repeatedly until returning to the start state.
Returns detailed information about all visited states, the cycle structure,
and celestial LRX coordinates.
}
\examples{
result <- get_reachable_states(1:10, c("1", "3"), k = 4)
writeLines(result$cycle_info)
}
