% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_best_random_combinations.R
\name{find_best_random_combinations}
\alias{find_best_random_combinations}
\title{Find Best Random Operation Sequences}
\usage{
find_best_random_combinations(
  moves,
  combo_length,
  n_samples,
  n_top,
  start_state,
  k
)
}
\arguments{
\item{moves}{Character vector of allowed operation symbols (e.g., c("1", "2", "3") or c("L", "R", "X"))}

\item{combo_length}{Integer, length of each operation sequence to test}

\item{n_samples}{Integer, number of random sequences to generate and test}

\item{n_top}{Integer, number of top results to return (sorted by cycle length)}

\item{start_state}{Integer vector, initial permutation state}

\item{k}{Integer, parameter for reverse operations}
}
\value{
Data frame with columns:
\item{combo_number}{Integer sequence number}
\item{combination}{String representation of the operation sequence}
\item{total_moves}{Cycle length for this sequence}
\item{unique_states_count}{Number of unique states visited in the cycle}
}
\description{
Generates random sequences of operations and evaluates their cycle lengths
to find sequences that produce the longest cycles in the Cayley graph.
Uses C++ with OpenMP for parallel evaluation of combinations.
}
\examples{
best <- find_best_random_combinations(
  moves = c("1", "2", "3"),
  combo_length = 10,
  n_samples = 50,
  n_top = 5,
  start_state = 1:10,
  k = 4
)
print(best)
}
