% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celestial.R
\name{calculate_midpoint_z}
\alias{calculate_midpoint_z}
\title{Midpoint Between Two Celestial Coordinates}
\usage{
calculate_midpoint_z(coords1, coords2)
}
\arguments{
\item{coords1}{List with theta, phi, omega_conformal (and optionally nL, nR, nX)}

\item{coords2}{List with theta, phi, omega_conformal (and optionally nL, nR, nX)}
}
\value{
List with theta, phi, z, z_bar, omega_conformal, nL, nR, nX
}
\description{
Computes the midpoint on the celestial sphere between two coordinate
sets by averaging Cartesian unit-sphere positions and re-projecting.
}
\examples{
c1 <- convert_LRX_to_celestial(10, 5, 3)
c2 <- convert_LRX_to_celestial(1, 1, 2)
mid <- calculate_midpoint_z(c1, c2)
mid$theta
}
