% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bidirectional_bfs.R
\name{bidirectional_bfs}
\alias{bidirectional_bfs}
\title{Bidirectional BFS Shortest Path}
\usage{
bidirectional_bfs(n, state1, state2, max_level, moves, k)
}
\arguments{
\item{n}{Integer, size of the permutation}

\item{state1}{Integer vector, start state}

\item{state2}{Integer vector, goal state}

\item{max_level}{Integer, maximum BFS depth in each direction}

\item{moves}{Character vector, allowed operations (e.g., c("1", "2", "3"))}

\item{k}{Integer, parameter for reverse operations}
}
\value{
Character vector of operations forming the shortest path,
or NULL if no path found within max_level
}
\description{
Finds the shortest path between two permutation states using
bidirectional breadth-first search. Expands from both the start
and goal states simultaneously, meeting in the middle.
}
\examples{
# Find path between two small states
path <- bidirectional_bfs(5, 1:5, c(2, 3, 4, 5, 1), max_level = 5,
                          moves = c("1", "2", "3"), k = 3)
path
}
