% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cat_ord_data}
\alias{cat_ord_data}
\title{Simulated Ordered Categorical Data}
\format{
A data.frame with 1000 rows and 5 variables.
\describe{
\item{X1}{Categorical version of \code{num_data$X1}, with 5 ordered levels a–e.}
\item{X2}{Categorical version of \code{num_data$X2}, with 5 ordered levels a–e.}
\item{X3}{Categorical version of \code{num_data$X3}, with 5 ordered levels a–e.}
\item{Z}{Categorical version of \code{num_data$Z}, with 5 ordered levels a–e.}
\item{Y}{Categorical version of \code{num_data$Y}, with 5 ordered levels a–e.}
}
}
\usage{
cat_ord_data
}
\description{
A dataset created by discretizing the continuous \code{num_data} into 5 ordered categorical levels per variable.
}
\details{
The R code used to generate this dataset is as follows:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{data(num_data)
cat_ord_data <- as.data.frame(
  lapply(num_data, function(x) cut(x, breaks = 5, labels = letters[1:5], ordered_result = TRUE))
)
}\if{html}{\out{</div>}}
}
\examples{
data(cat_ord_data)
head(cat_ord_data)

}
\seealso{
\link{num_data}
}
\concept{dataset}
\keyword{datasets}
