% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boss-fci.R
\name{boss_fci}
\alias{boss_fci}
\title{BOSS-FCI Algorithm for Causal Discovery}
\usage{
boss_fci(engine = "tetrad", score, test, alpha = 0.05, ...)
}
\arguments{
\item{engine}{Character; which engine to use. Must be one of:
\describe{
\item{\code{"tetrad"}}{\pkg{Tetrad} Java library.}
}}

\item{score}{Character; name of the scoring function to use.}

\item{test}{Character; name of the conditional‐independence test.}

\item{alpha}{Numeric; significance level for the CI tests.}

\item{...}{Additional arguments passed to the chosen engine (e.g. score and
algorithm parameters).}
}
\description{
Run the BOSS-FCI (Best Order Score Search FCI) algorithm for causal discovery using one of several engines. This
uses BOSS in place of FGES for the initial step in the GFCI algorithm.
}
\details{
For specific details on the supported scores, and parameters for each engine, see:
\itemize{
\item \link{TetradSearch} for \pkg{Tetrad}.
}
}
\section{Recommendation}{

While it is possible to call the function returned directly with a data frame,
we recommend using \code{\link[=disco]{disco()}}. This provides a consistent interface and handles knowledge
integration.
}

\section{Value}{

A function that takes a single argument \code{data} (a data frame). When called,
this function returns a list containing:
\itemize{
\item \code{knowledge} A \code{Knowledge} object with the background knowledge
used in the causal discovery algorithm. See \code{\link[=knowledge]{knowledge()}} for how to construct it.
\item \code{caugi} A \code{\link[caugi:caugi]{caugi::caugi}} object representing the learned causal graph.
This graph is a PAG (Partial Ancestral Graph), but since PAGs are not yet
natively supported in \code{caugi}, it is currently stored with class \code{UNKNOWN}.
}
}

\examples{
data(tpc_example)

# Requires Tetrad to be installed
if (verify_tetrad()$installed && verify_tetrad()$java_ok) {
  # Recommended path using disco()
  boss_fci_tetrad <- boss_fci(
    engine = "tetrad",
    score = "sem_bic",
    test = "fisher_z"
  )
  disco(tpc_example, boss_fci_tetrad)

  # or using boss_fci_tetrad directly
  boss_fci_tetrad(tpc_example)
}

#### With tier knowledge ####
if (verify_tetrad()$installed && verify_tetrad()$java_ok) {
  kn <- knowledge(
    tpc_example,
    tier(
      child ~ tidyselect::starts_with("child"),
      youth ~ tidyselect::starts_with("youth"),
      oldage ~ tidyselect::starts_with("oldage")
    )
  )

  # Recommended path using disco()
  boss_fci_tetrad <- boss_fci(
    engine = "tetrad",
    score = "sem_bic",
    test = "fisher_z"
  )
  disco(tpc_example, boss_fci_tetrad, knowledge = kn)

  # or using boss_fci_tetrad directly
  boss_fci_tetrad <- boss_fci_tetrad |> set_knowledge(kn)
  boss_fci_tetrad(tpc_example)
}

# With all algorithm arguments specified
if (verify_tetrad()$installed && verify_tetrad()$java_ok) {
  boss_fci_tetrad <- boss_fci(
    engine = "tetrad",
    score = "poisson_prior",
    test = "rank_independence",
    depth = 3,
    max_disc_path_length = 5,
    use_bes = FALSE,
    use_heuristic = FALSE,
    complete_rule_set_used = FALSE,
    guarantee_pag = TRUE
  )
  disco(tpc_example, boss_fci_tetrad)
}
}
\seealso{
Other causal discovery algorithms: 
\code{\link{boss}()},
\code{\link{fci}()},
\code{\link{ges}()},
\code{\link{gfci}()},
\code{\link{grasp}()},
\code{\link{grasp_fci}()},
\code{\link{gs}()},
\code{\link{iamb-family}},
\code{\link{pc}()},
\code{\link{sp_fci}()},
\code{\link{tfci}()},
\code{\link{tges}()},
\code{\link{tpc}()}
}
\concept{causal discovery algorithms}
\concept{cd_algorithms}
