% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shell.R
\name{page_actionbar}
\alias{page_actionbar}
\title{Create a Shell with Action Bar Layout}
\usage{
page_actionbar(
  ...,
  title = NULL,
  header_actions = NULL,
  actions = NULL,
  panel_content = NULL,
  panel_position = c("start", "end"),
  panel_width = c("m", "s", "l"),
  footer = NULL
)
}
\arguments{
\item{...}{Main content area (typically a map or primary view)}

\item{title}{Application title shown in the navigation header}

\item{header_actions}{Optional actions for the header (e.g., user menu, settings).
These will be placed in the \code{content-end} slot of the navigation.}

\item{actions}{A \code{\link[=calcite_action_bar]{calcite_action_bar()}} component to slot alongside the panel.}

\item{panel_content}{A \code{\link[=calcite_panel]{calcite_panel()}} shown when an action is selected.}

\item{panel_position}{Position of the panel: \code{"start"} (left) or \code{"end"} (right).}

\item{panel_width}{Width of the shell panel: \code{"s"}, \code{"m"}, or \code{"l"}.}

\item{footer}{Optional footer content}
}
\value{
An object of class \code{calcite_component} containing a configured shell
}
\description{
A convenience function that creates a common layout pattern: a shell with
a navigation header, an action bar, and a side panel. This is ideal for
map-based applications or tools with multiple layers/options.
}
\examples{
page_actionbar(
  title = "Wildlife Areas",
  actions = calcite_action_bar(
    calcite_action(text = "Add", icon = "plus"),
    calcite_action(text = "Layers", icon = "layers", active = TRUE)
  ),
  panel_content = calcite_panel(
    heading = "Layers",
    "Layer controls here"
  ),
  "Map content here"
)
}
