% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slider.R
\name{calcite_slider}
\alias{calcite_slider}
\title{Create a Calcite Slider Component}
\usage{
calcite_slider(
  id = NULL,
  value = NULL,
  min = 0,
  max = 100,
  step = 1,
  min_value = NULL,
  max_value = NULL,
  label_handles = NULL,
  label_ticks = NULL,
  label_text = NULL,
  ticks = NULL,
  disabled = NULL,
  required = NULL,
  scale = NULL,
  snap = NULL,
  precise = NULL,
  mirrored = NULL,
  fill_placement = NULL,
  histogram = NULL,
  histogram_stops = NULL,
  group_separator = NULL,
  page_step = NULL,
  min_label = NULL,
  max_label = NULL,
  name = NULL,
  form = NULL,
  numbering_system = NULL,
  status = NULL,
  validation_icon = NULL,
  validation_message = NULL,
  ...
)
}
\arguments{
\item{id}{Component ID (required for Shiny reactivity)}

\item{value}{Initial value (for single slider) or NULL}

\item{min}{Minimum selectable value (default: 0)}

\item{max}{Maximum selectable value (default: 100)}

\item{step}{Increment step for up/down arrows and keyboard (default: 1)}

\item{min_value}{For range sliders, the lower bound value}

\item{max_value}{For range sliders, the upper bound value}

\item{label_handles}{Whether to display numeric labels on handles (default: FALSE)}

\item{label_ticks}{Whether to display numeric labels on tick marks (default: FALSE)}

\item{label_text}{Accessible label text for the component}

\item{ticks}{Interval for displaying tick marks on the number line}

\item{disabled}{Whether the slider is disabled (default: FALSE)}

\item{required}{Whether a value is required for form submission (default: FALSE)}

\item{scale}{Size of the slider: "s" (small), "m" (medium), or "l" (large)}

\item{snap}{Whether to enable snap-to-step on mouse interaction (default: FALSE)}

\item{precise}{Whether to use finer positioning for handles (default: FALSE)}

\item{mirrored}{Whether to mirror the slider (default: FALSE)}

\item{fill_placement}{Where to display the fill: "start", "end", or "none"}

\item{histogram}{A 2-column numeric matrix or data.frame for histogram display}

\item{histogram_stops}{Color stops for histogram display}

\item{group_separator}{Whether to display thousand separators in numbers (default: FALSE)}

\item{page_step}{Interval to move with Page Up/Down keys}

\item{min_label}{Accessible label for the minimum handle (for screen readers)}

\item{max_label}{Accessible label for the maximum handle (for screen readers)}

\item{name}{Name attribute for form submission}

\item{form}{Associated form element ID}

\item{numbering_system}{Numbering system to use: "arab", "arabext", or "latn"}

\item{status}{Validation state: "idle", "valid", or "invalid"}

\item{validation_icon}{Icon to display for validation feedback}

\item{validation_message}{Message displayed for validation feedback}

\item{...}{Additional attributes passed to the component}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a slider input for selecting numeric values. Supports both single-value
and range selection (dual handles).
}
\details{
\subsection{Shiny Integration}{

The slider emits two types of events:
\itemize{
\item \strong{\code{calciteSliderChange}} - Fires when the user releases the handle (debounced, final value)
\item \strong{\code{calciteSliderInput}} - Fires continuously during drag (use with caution for expensive operations)
}

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$value} - Current value (single slider) or array of \verb{[minValue, maxValue]} (range slider)
\item \verb{$min} / \verb{$max} - Slider bounds
\item \verb{$step} - Step increment
\item \verb{$disabled} - Whether disabled
\item Other component properties
}

\strong{Single-value slider:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{observeEvent(input$my_slider, \{
  current_value <- input$my_slider$value
  print(paste("Slider value:", current_value))
\})
}\if{html}{\out{</div>}}

\strong{Range slider (dual handles):}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Provide both min_value and max_value to create a range slider
calcite_slider(
  id = "range_slider",
  min = 0,
  max = 100,
  min_value = 20,
  max_value = 80
)

observeEvent(input$range_slider, \{
  lower <- input$range_slider$minValue
  upper <- input$range_slider$maxValue
  print(paste("Range:", lower, "to", upper))
\})
}\if{html}{\out{</div>}}

\strong{Update from server:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Update single value
update_calcite("my_slider", value = 50)

# Update range
update_calcite("range_slider", minValue = 30, maxValue = 70)
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic slider
calcite_slider(
  id = "my_slider",
  value = 50,
  min = 0,
  max = 100,
  step = 5
)

# Slider with ticks and labels
calcite_slider(
  id = "temperature",
  value = 72,
  min = 32,
  max = 212,
  step = 1,
  ticks = 10,
  label_handles = TRUE,
  label_ticks = TRUE
)

# Range slider (dual handles)
calcite_slider(
  id = "price_range",
  min = 0,
  max = 1000,
  min_value = 100,
  max_value = 500,
  step = 10,
  label_handles = TRUE
)

# Shiny example
if (interactive()) {
  library(shiny)

  ui <- calcite_shell(
    calcite_card(
      heading = "Slider Example",
      calcite_label(
        "Choose a value",
        calcite_slider(
          id = "my_slider",
          value = 50,
          min = 0,
          max = 100,
          step = 5,
          label_handles = TRUE
        )
      ),
      verbatimTextOutput("slider_value")
    )
  )

  server <- function(input, output, session) {
    output$slider_value <- renderPrint({
      paste("Current value:", input$my_slider$value)
    })
  }

  shinyApp(ui, server)
}
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/slider/}{Official Documentation}
}
