% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shell-panel.R
\name{calcite_shell_panel}
\alias{calcite_shell_panel}
\title{Create a Calcite Shell Panel Component}
\usage{
calcite_shell_panel(
  ...,
  collapsed = NULL,
  display_mode = NULL,
  height = NULL,
  message_overrides = NULL,
  resizable = NULL,
  width = NULL,
  action_bar = NULL
)
}
\arguments{
\item{...}{Default slot content. Typically a single \code{\link[=calcite_panel]{calcite_panel()}}.}

\item{collapsed}{When \code{TRUE}, hides the component's content area. Default: \code{FALSE}}

\item{display_mode}{Specifies the display mode:
\itemize{
\item \code{"dock"} (default): full height, pushes center content aside
\item \code{"overlay"}: full height, displays on top of center content
\item \code{"float-content"}: not full height, content detached from action bar, on top of center content
\item \code{"float-all"}: detaches both panel and action bar on top of center content
}}

\item{height}{Specifies the component's height.}

\item{message_overrides}{Override individual strings used by the component.}

\item{resizable}{When \code{TRUE} and \code{display_mode} is \code{"dock"} or \code{"overlay"},
the content area is resizable. Default: \code{FALSE}}

\item{width}{Specifies the component's width: \code{"s"}, \code{"m"}, or \code{"l"}.}

\item{action_bar}{Content for the \code{action-bar} slot. Typically a
\code{\link[=calcite_action_bar]{calcite_action_bar()}} component.}
}
\value{
An object of class \code{calcite_component}
}
\description{
Shell Panel is a layout container that slots into \code{\link[=calcite_shell]{calcite_shell()}} via
\code{panel_start} or \code{panel_end}. It sits adjacent to or on top of the main
content area. Pass a \code{\link[=calcite_panel]{calcite_panel()}} (typically containing \code{\link[=calcite_block]{calcite_block()}}
components) as the default content, and optionally a \code{\link[=calcite_action_bar]{calcite_action_bar()}}
in the \code{action_bar} slot.
}
\details{
\subsection{Usage}{

Shell Panel is the recommended wrapper when placing panels inside
\code{\link[=calcite_shell]{calcite_shell()}}'s \code{panel_start} or \code{panel_end} slots. It controls display
mode, width, collapsibility, and action bar placement.

Multiple Shell Panels can be open simultaneously, unlike \code{\link[=calcite_sheet]{calcite_sheet()}}.
It does not provide a page-blocking scrim and is not intended to interrupt
the main application workflow.
}
}
\examples{
calcite_shell(
  panel_start = calcite_shell_panel(
    calcite_panel(
      heading = "Layers",
      calcite_block(
        heading = "Options",
        collapsible = TRUE,
        expanded = TRUE
      )
    )
  ),
  calcite_panel(heading = "Map View")
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/shell-panel/}{Official Documentation}
}
