% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrim.R
\name{calcite_scrim}
\alias{calcite_scrim}
\title{Create a Calcite Scrim Component}
\usage{
calcite_scrim(..., id = NULL, loading = FALSE)
}
\arguments{
\item{...}{Main content for the scrim (default slot — primarily loading information)}

\item{id}{Component ID (required for Shiny reactivity)}

\item{loading}{When \code{TRUE}, a busy indicator is displayed in the center. Default: \code{FALSE}.}
}
\value{
An object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
Scrims are an overlay placed on top of content to show disabled or loading
states. By default, Scrim positions to the extent of its closest parent.
To display a Scrim with custom positioning, add \code{position: relative} styling
to its closest parent container.
}
\details{
\subsection{Shiny Integration}{

When given an \code{id}, the scrim reports its state as \code{input$id} — a named list:
\itemize{
\item \verb{$loading} — logical, whether the loading indicator is shown
}

Use \code{update_calcite(id, loading = TRUE/FALSE)} to toggle the loading state
from the server.
}

\subsection{Positioning}{

Scrim fills its closest positioned parent. Wrap the area you want to cover
in a container with \code{position: relative} so the scrim covers the right region.
}
}
\examples{
calcite_scrim(id = "my_scrim", loading = TRUE)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/scrim/}{Official Documentation}
}
